/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceIoDirent
extends pspAbstractMemoryMappedStructure {
    public SceIoStat stat;
    public String filename;
    public int extendedInfoAddr;
    public int dummy;
    private boolean useExtendedInfo;

    public SceIoDirent(SceIoStat stat, String filename) {
        this.stat = stat;
        this.filename = filename;
    }

    @Override
    protected void read() {
        this.stat = new SceIoStat();
        this.read(this.stat);
        this.filename = this.readStringNZ(256);
        this.extendedInfoAddr = this.read32();
        this.dummy = this.read32();
    }

    private static String convertFileNameTo83(String fileName) {
        String ext;
        String name;
        if (fileName == null) {
            return null;
        }
        fileName = fileName.replace("+", "_");
        int lastDot = (fileName = fileName.toUpperCase()).lastIndexOf(".");
        if (lastDot < 0) {
            name = fileName;
            ext = "";
        } else {
            name = fileName.substring(0, lastDot);
            ext = fileName.substring(lastDot + 1);
        }
        name = name.replace(".", "");
        if (ext.length() > 3) {
            ext = ext.substring(0, 3);
        }
        if (name.length() > 8) {
            name = name.substring(0, 6) + "~1";
        }
        return name + "." + ext;
    }

    @Override
    protected void write() {
        this.write(this.stat);
        this.writeStringNZ(256, this.filename);
        if (this.useExtendedInfo) {
            if (this.extendedInfoAddr == 0) {
                this.extendedInfoAddr = this.read32();
            }
            if (Memory.isAddressGood(this.extendedInfoAddr)) {
                if (Modules.SysMemUserForUserModule.hleKernelGetCompiledSdkVersion() <= 50855935) {
                    Utilities.writeStringNZ(this.mem, this.extendedInfoAddr + 0, 13, SceIoDirent.convertFileNameTo83(this.filename));
                    Utilities.writeStringZ(this.mem, this.extendedInfoAddr + 13, this.filename);
                } else {
                    int size = this.mem.read32(this.extendedInfoAddr);
                    if (size == 1044) {
                        Utilities.writeStringNZ(this.mem, this.extendedInfoAddr + 4, 13, SceIoDirent.convertFileNameTo83(this.filename));
                        Utilities.writeStringNZ(this.mem, this.extendedInfoAddr + 20, 1024, this.filename);
                    }
                }
            }
        }
    }

    public void setUseExtendedInfo(boolean useExtendedInfo) {
        this.useExtendedInfo = useExtendedInfo;
    }

    @Override
    public int sizeof() {
        return 352;
    }

    @Override
    public String toString() {
        return String.format("fileName='%s', stat=%s", this.filename, this.stat);
    }
}

